%% TACH_NOISE
% Plots a sample speed and input voltage response depicting the noise found
% in the measured tachometer signal. The steady-state error is computed as
% well.
%
%% Estimated Tachometer Noise
% Rated peak-to-peak ripple (% of tach output voltage)
Kn = 7;
% Load gear speed (rad/s)
w_l = 7.5;
% Estimate noise
D_wl = Kn / 100 * w_l
%
%% Measured Tachometer Noise
% Load file
% load('data_cnst_spd_rsp_vm.mat')
% load('data_cnst_spd_rsp_wl.mat')
% Load data
u = data_vm(:,2);
t = data_spd(:,1);
yd = data_spd(:,2);
y = data_spd(:,3);
% Plot
subplot(2,1,1);
plot(t,yd,'b',t,y,'r-');
axis([10 11 7 8])
ylabel('\omega_l (rad/s)');
subplot(2,1,2);
plot(t,u,'r-');
axis([10 11 0 10])
ylabel('V_m (V)');
xlabel('time (s)');
% Steady-state error
e_ss_meas = mean(yd) - mean(y)
% Ripple peak-to-peak
Kn_meas = 7.6-7.3
var(y)